export interface Product {
  id: string;
  name: string;
  shortDescription: string;
  fullDescription: string;
  features: string[];
  price: number;
  originalPrice: number;
  image: string;
  category: string;
  deliveryTime: string; // e.g., "Instant via Email"
  rating: number;
  reviewsCount: number;
}

export interface CartItem extends Product {
  quantity: number;
}

export interface Testimonial {
  id: number;
  name: string;
  role: string;
  content: string;
  avatar: string;
}

export enum Page {
  HOME = 'HOME',
  PRODUCTS = 'PRODUCTS',
  PRODUCT_DETAIL = 'PRODUCT_DETAIL',
  ABOUT = 'ABOUT',
  CONTACT = 'CONTACT',
  FAQ = 'FAQ',
  TERMS = 'TERMS',
  REFUND = 'REFUND',
  CHECKOUT = 'CHECKOUT'
}