import React from 'react';

export const Terms: React.FC = () => {
  return (
    <div className="bg-gray-50 py-16 px-4 sm:px-6 lg:px-8">
      <div className="max-w-3xl mx-auto bg-white p-8 rounded-xl shadow-sm">
        <h1 className="text-3xl font-bold text-gray-900 mb-6">Terms and Conditions</h1>
        <div className="prose prose-sm text-gray-600">
          <p>Last updated: October 2023</p>
          <h3 className="font-bold text-gray-800 mt-4">1. Acceptance of Terms</h3>
          <p>By accessing and placing an order with SubStore, you confirm that you are in agreement with and bound by the terms of service contained in the Terms & Conditions outlined below.</p>
          
          <h3 className="font-bold text-gray-800 mt-4">2. Products and Services</h3>
          <p>We sell digital goods. We do not sell physical products. Delivery is electronic via email.</p>
          
          <h3 className="font-bold text-gray-800 mt-4">3. Account Usage</h3>
          <p>You agree not to share your account credentials publicly. Changing the password or email of shared accounts (like Netflix) is strictly prohibited and will void your warranty.</p>
          
          <h3 className="font-bold text-gray-800 mt-4">4. Liability</h3>
          <p>SubStore is not liable for any direct, indirect, special, incidental or consequential damages, including, but not limited to, loss of data or profit, arising out of the use, or the inability to use, the materials on this site.</p>
        </div>
      </div>
    </div>
  );
};