import { Product, Testimonial } from './types';

export const PRODUCTS: Product[] = [
  {
    id: 'canva-pro',
    name: 'Canva Pro Lifetime',
    shortDescription: 'Design like a pro with unlimited access to premium tools.',
    fullDescription: 'Unlock the full power of Canva with our Pro subscription. Get access to millions of premium photos, fonts, and templates. Remove backgrounds instantly, resize designs seamlessly, and collaborate with your team in real-time. This is a private account upgrade delivered to your email.',
    features: ['100+ Million Premium Stock Photos', 'Magic Resize', 'Background Remover', '1TB Cloud Storage', 'Social Media Scheduler'],
    price: 14.99,
    originalPrice: 119.99,
    image: 'https://picsum.photos/id/1/600/600',
    category: 'Design',
    deliveryTime: 'Instant Email Delivery',
    rating: 4.9,
    reviewsCount: 1240
  },
  {
    id: 'netflix-uhd',
    name: 'Netflix Premium (4K)',
    shortDescription: 'Watch your favorite shows in stunning 4K Ultra HD.',
    fullDescription: 'Experience Netflix in the highest quality available. Our Premium subscription supports 4K HDR streaming and allows watching on 4 screens simultaneously. No ads, just pure entertainment delivered straight to your inbox.',
    features: ['4K Ultra HD', '4 Concurrent Screens', 'Ad-free Streaming', 'Download on 4 devices', 'Spatial Audio'],
    price: 9.99,
    originalPrice: 19.99,
    image: 'https://picsum.photos/id/2/600/600',
    category: 'Streaming',
    deliveryTime: 'Instant Email Delivery',
    rating: 4.8,
    reviewsCount: 3421
  },
  {
    id: 'youtube-premium',
    name: 'YouTube Premium',
    shortDescription: 'Ad-free videos, background play, and YouTube Music.',
    fullDescription: 'Enjoy YouTube without interruptions. YouTube Premium gives you ad-free videos, the ability to play videos in the background while using other apps, and full access to YouTube Music Premium.',
    features: ['Ad-free videos', 'Background Play', 'YouTube Music Included', 'Offline Downloads', 'Originals Access'],
    price: 5.99,
    originalPrice: 13.99,
    image: 'https://picsum.photos/id/3/600/600',
    category: 'Streaming',
    deliveryTime: 'Instant Email Delivery',
    rating: 4.9,
    reviewsCount: 890
  },
  {
    id: 'chatgpt-plus',
    name: 'ChatGPT Plus',
    shortDescription: 'Access GPT-4, faster response times, and priority access.',
    fullDescription: 'Supercharge your productivity with ChatGPT Plus. Gain access to the powerful GPT-4 model, experience faster response speeds, and get priority access during peak times. Perfect for developers, writers, and professionals.',
    features: ['Access to GPT-4', 'Browsing & Plugins', 'Advanced Data Analysis', 'Faster Response Speed', 'Priority Access'],
    price: 19.99,
    originalPrice: 20.00,
    image: 'https://picsum.photos/id/4/600/600',
    category: 'Productivity',
    deliveryTime: 'Instant Email Delivery',
    rating: 5.0,
    reviewsCount: 5600
  },
  {
    id: 'disney-plus',
    name: 'Disney+ Bundle',
    shortDescription: 'The home of Disney, Pixar, Marvel, Star Wars, and Nat Geo.',
    fullDescription: 'Stream the best stories in the world from Disney, Pixar, Marvel, Star Wars, and National Geographic. This bundle offers something for everyone, with ad-free viewing and unlimited downloads.',
    features: ['Exclusive Originals', 'IMAX Enhanced', 'Parental Controls', 'GroupWatch', 'Offline Viewing'],
    price: 4.99,
    originalPrice: 10.99,
    image: 'https://picsum.photos/id/5/600/600',
    category: 'Streaming',
    deliveryTime: 'Instant Email Delivery',
    rating: 4.7,
    reviewsCount: 1543
  },
  {
    id: 'prime-video',
    name: 'Prime Video',
    shortDescription: 'Exclusive Amazon Originals and thousands of movies.',
    fullDescription: 'Watch exclusive Amazon Originals, popular movies, and hit TV shows. Enjoy X-Ray for movies and TV shows to identify actors and songs, and download titles for offline viewing.',
    features: ['Exclusive Originals', 'X-Ray Features', '4K UHD available', 'Offline Downloads', 'Multiple Profiles'],
    price: 3.99,
    originalPrice: 8.99,
    image: 'https://picsum.photos/id/6/600/600',
    category: 'Streaming',
    deliveryTime: 'Instant Email Delivery',
    rating: 4.6,
    reviewsCount: 980
  }
];

export const TESTIMONIALS: Testimonial[] = [
  {
    id: 1,
    name: "Sarah Johnson",
    role: "Freelance Designer",
    content: "I was skeptical at first, but the Canva Pro account was delivered instantly. It's saved me hundreds of dollars this year alone!",
    avatar: "https://picsum.photos/id/64/100/100"
  },
  {
    id: 2,
    name: "Michael Chen",
    role: "Software Engineer",
    content: "The ChatGPT Plus subscription works perfectly. Excellent customer support when I had a question about renewal.",
    avatar: "https://picsum.photos/id/91/100/100"
  },
  {
    id: 3,
    name: "Emily Davis",
    role: "Student",
    content: "Got Netflix and YouTube Premium for the price of a coffee. Highly recommend this site for students on a budget.",
    avatar: "https://picsum.photos/id/177/100/100"
  }
];