import React from 'react';

export const Refund: React.FC = () => {
  return (
    <div className="bg-gray-50 py-16 px-4 sm:px-6 lg:px-8">
      <div className="max-w-3xl mx-auto bg-white p-8 rounded-xl shadow-sm">
        <h1 className="text-3xl font-bold text-gray-900 mb-6">Refund Policy</h1>
        <div className="prose prose-sm text-gray-600">
          <p>We want you to be completely satisfied with our products. Here is our refund policy:</p>
          
          <h3 className="font-bold text-gray-800 mt-4">Eligibility for Refunds</h3>
          <ul className="list-disc pl-5 space-y-2">
            <li>If the product does not work as described.</li>
            <li>If we are unable to replace a non-working account within 24 hours.</li>
            <li>The request is made within 30 days of purchase.</li>
          </ul>
          
          <h3 className="font-bold text-gray-800 mt-4">Non-refundable Circumstances</h3>
          <ul className="list-disc pl-5 space-y-2">
            <li>You simply changed your mind after the product was delivered and accessed.</li>
            <li>You violated the Terms of Service (e.g., changing passwords on shared accounts).</li>
          </ul>
          
          <h3 className="font-bold text-gray-800 mt-4">How to Request a Refund</h3>
          <p>Contact us at support@substore.com with your order number and a description of the issue. We will review your request within 24 hours.</p>
        </div>
      </div>
    </div>
  );
};