import React from 'react';
import { Link } from 'react-router-dom';
import { ArrowRight, CheckCircle, Shield, Clock, CreditCard, Star } from 'lucide-react';
import { PRODUCTS, TESTIMONIALS } from '../constants';
import { ProductCard } from '../components/ProductCard';

export const Home: React.FC = () => {
  const featuredProducts = PRODUCTS.slice(0, 4);

  return (
    <div className="animate-fade-in">
      {/* Hero Section */}
      <section className="relative bg-indigo-900 text-white overflow-hidden">
        <div className="absolute inset-0 bg-[url('https://picsum.photos/id/48/1920/1080')] bg-cover bg-center opacity-20"></div>
        <div className="absolute inset-0 bg-gradient-to-r from-indigo-900 via-indigo-900/90 to-transparent"></div>
        
        <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-24 lg:py-32">
          <div className="lg:w-2/3">
            <h1 className="text-4xl md:text-6xl font-extrabold tracking-tight mb-6">
              Premium Digital <br />
              <span className="text-transparent bg-clip-text bg-gradient-to-r from-teal-300 to-indigo-300">Subscriptions for Less</span>
            </h1>
            <p className="text-xl text-indigo-100 mb-8 max-w-2xl leading-relaxed">
              Get instant access to Canva Pro, Netflix, YouTube Premium, and more at unbeatable prices. 100% secure, private, and guaranteed.
            </p>
            <div className="flex flex-col sm:flex-row gap-4">
              <Link to="/products" className="inline-flex justify-center items-center px-8 py-4 border border-transparent text-lg font-medium rounded-xl text-indigo-900 bg-white hover:bg-gray-50 transition-colors shadow-lg">
                Explore Store
              </Link>
              <Link to="/about" className="inline-flex justify-center items-center px-8 py-4 border border-white/30 text-lg font-medium rounded-xl text-white hover:bg-white/10 transition-colors backdrop-blur-sm">
                How It Works
              </Link>
            </div>
            
            <div className="mt-12 flex items-center gap-6 text-sm font-medium text-indigo-200">
              <div className="flex items-center gap-2"><CheckCircle className="h-5 w-5 text-teal-400" /> Instant Delivery</div>
              <div className="flex items-center gap-2"><CheckCircle className="h-5 w-5 text-teal-400" /> 24/7 Support</div>
              <div className="flex items-center gap-2"><CheckCircle className="h-5 w-5 text-teal-400" /> Money Back Guarantee</div>
            </div>
          </div>
        </div>
      </section>

      {/* Featured Products */}
      <section className="py-20 bg-gray-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <h2 className="text-3xl font-bold text-gray-900 sm:text-4xl">Trending Subscriptions</h2>
            <p className="mt-4 text-lg text-gray-600">The most popular digital tools and streaming services, handpicked for you.</p>
          </div>
          
          <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8">
            {featuredProducts.map(product => (
              <ProductCard key={product.id} product={product} />
            ))}
          </div>
          
          <div className="mt-12 text-center">
            <Link to="/products" className="inline-flex items-center text-indigo-600 font-semibold hover:text-indigo-700">
              View All Products <ArrowRight className="ml-2 h-5 w-5" />
            </Link>
          </div>
        </div>
      </section>

      {/* Why Choose Us */}
      <section className="py-20 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div>
              <h2 className="text-3xl font-bold text-gray-900 mb-6">Why Choose SubStore?</h2>
              <p className="text-gray-600 text-lg mb-8 leading-relaxed">
                We are a dedicated team providing legal, cost-effective access to premium digital services. We leverage group licensing and regional pricing to pass savings directly to you.
              </p>
              
              <div className="space-y-6">
                <div className="flex items-start">
                  <div className="flex-shrink-0">
                    <div className="flex items-center justify-center h-12 w-12 rounded-lg bg-indigo-100 text-indigo-600">
                      <Clock className="h-6 w-6" />
                    </div>
                  </div>
                  <div className="ml-4">
                    <h3 className="text-lg font-medium text-gray-900">Instant Automated Delivery</h3>
                    <p className="mt-2 text-gray-500">Receive your login credentials or upgrade link instantly via email after payment.</p>
                  </div>
                </div>

                <div className="flex items-start">
                  <div className="flex-shrink-0">
                    <div className="flex items-center justify-center h-12 w-12 rounded-lg bg-indigo-100 text-indigo-600">
                      <Shield className="h-6 w-6" />
                    </div>
                  </div>
                  <div className="ml-4">
                    <h3 className="text-lg font-medium text-gray-900">Secure & Private</h3>
                    <p className="mt-2 text-gray-500">We use SSL encryption for payments. Your personal data is never shared with third parties.</p>
                  </div>
                </div>

                <div className="flex items-start">
                  <div className="flex-shrink-0">
                    <div className="flex items-center justify-center h-12 w-12 rounded-lg bg-indigo-100 text-indigo-600">
                      <CreditCard className="h-6 w-6" />
                    </div>
                  </div>
                  <div className="ml-4">
                    <h3 className="text-lg font-medium text-gray-900">Best Price Guarantee</h3>
                    <p className="mt-2 text-gray-500">Found a lower price? We'll match it. We are committed to affordability.</p>
                  </div>
                </div>
              </div>
            </div>
            
            <div className="relative">
              <div className="absolute inset-0 bg-indigo-600 rounded-3xl transform rotate-3 opacity-10"></div>
              <img 
                src="https://picsum.photos/id/3/800/800" 
                alt="Digital Lifestyle" 
                className="relative rounded-3xl shadow-2xl"
              />
            </div>
          </div>
        </div>
      </section>

      {/* Testimonials */}
      <section className="py-20 bg-gray-900 text-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <h2 className="text-3xl font-bold mb-4">Trusted by 10,000+ Customers</h2>
            <div className="flex justify-center items-center gap-1 mb-2">
              {[...Array(5)].map((_, i) => <Star key={i} className="h-6 w-6 text-yellow-400 fill-current" />)}
            </div>
            <p className="text-gray-400">4.9/5 Average Rating</p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            {TESTIMONIALS.map(testimonial => (
              <div key={testimonial.id} className="bg-gray-800 p-8 rounded-2xl border border-gray-700">
                <div className="flex items-center mb-6">
                  <img src={testimonial.avatar} alt={testimonial.name} className="h-12 w-12 rounded-full mr-4" />
                  <div>
                    <h4 className="font-bold">{testimonial.name}</h4>
                    <p className="text-sm text-gray-400">{testimonial.role}</p>
                  </div>
                </div>
                <p className="text-gray-300 italic">"{testimonial.content}"</p>
              </div>
            ))}
          </div>
        </div>
      </section>
      
      {/* Call to Action */}
      <section className="py-20 bg-indigo-600">
        <div className="max-w-4xl mx-auto px-4 text-center">
          <h2 className="text-3xl md:text-4xl font-bold text-white mb-8">Ready to upgrade your digital life?</h2>
          <Link to="/products" className="inline-block px-10 py-5 bg-white text-indigo-600 text-xl font-bold rounded-xl hover:bg-gray-100 transition-colors shadow-xl">
            View All Offers
          </Link>
          <p className="mt-6 text-indigo-200 text-sm">30-Day Money Back Guarantee • Instant Delivery • Cancel Anytime</p>
        </div>
      </section>
    </div>
  );
};