import React from 'react';

const faqs = [
  {
    question: "How is the subscription delivered?",
    answer: "Once your payment is confirmed, you will receive an email immediately with your login credentials or an upgrade link, depending on the service."
  },
  {
    question: "Is this legal?",
    answer: "Yes. We utilize legitimate methods such as family sharing plans and corporate bulk discounts to provide these prices. You are not buying hacked accounts."
  },
  {
    question: "What if my subscription stops working?",
    answer: "We offer a full warranty for the duration of your purchased period. If you experience any issues, contact support and we will fix it or replace it immediately."
  },
  {
    question: "Can I use my own email?",
    answer: "For upgrade services (like Canva Pro or YouTube Premium), yes, we upgrade your existing account. For others (like Netflix), we typically provide a new account."
  },
  {
    question: "Do you offer refunds?",
    answer: "Yes, we have a 30-day money-back guarantee if the service does not work as described and we cannot resolve the issue."
  }
];

export const FAQ: React.FC = () => {
  return (
    <div className="bg-white py-16 px-4 sm:px-6 lg:px-8">
      <div className="max-w-3xl mx-auto">
        <h2 className="text-3xl font-extrabold text-gray-900 text-center mb-12">Frequently Asked Questions</h2>
        <dl className="space-y-8">
          {faqs.map((faq, index) => (
            <div key={index} className="border-b border-gray-200 pb-8">
              <dt className="text-lg leading-6 font-medium text-gray-900 mb-2">{faq.question}</dt>
              <dd className="text-base text-gray-500">{faq.answer}</dd>
            </div>
          ))}
        </dl>
      </div>
    </div>
  );
};