import React from 'react';

export const About: React.FC = () => {
  return (
    <div className="bg-white py-16 px-4 sm:px-6 lg:px-8">
      <div className="max-w-3xl mx-auto text-center">
        <h2 className="text-3xl font-extrabold text-gray-900 sm:text-4xl">About SubStore</h2>
        <p className="mt-4 text-lg text-gray-500">
          We are dedicated to making premium digital services accessible to everyone.
        </p>
      </div>
      <div className="mt-12 max-w-4xl mx-auto prose prose-indigo text-gray-500">
        <p className="mb-6">
          Founded in 2023, SubStore began with a simple mission: to lower the barrier of entry for premium digital tools and entertainment. We realized that many subscriptions were becoming unaffordable for students, freelancers, and families.
        </p>
        <p className="mb-6">
          By leveraging family plans, corporate bulk licensing, and regional pricing strategies, we are able to offer fully legal, legitimate access to services like Canva Pro, Netflix, and more at a fraction of the standard retail cost.
        </p>
        <h3 className="text-xl font-bold text-gray-900 mb-3">Our Promise</h3>
        <ul className="list-disc pl-5 mb-6 space-y-2">
          <li><strong>Legitimacy:</strong> All accounts are legally obtained. We do not deal in hacked or stolen credentials.</li>
          <li><strong>Support:</strong> Our team is available 24/7 to assist with setup or renewal issues.</li>
          <li><strong>Warranty:</strong> Every purchase is backed by our full warranty for the duration of the subscription.</li>
        </ul>
        <p>
          Join thousands of satisfied customers who have upgraded their digital lifestyle with SubStore.
        </p>
      </div>
    </div>
  );
};